<?php

return [
    'appointment_calendar' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-calendar',
        'color' => '#bb0c90',
        'has_statistics' => false,
        'themable' => true,
        'display_dynamic_name' => 'name',
        'whitelisted_thumbnail_image_extensions' => ['jpg', 'jpeg', 'png', 'svg', 'gif', 'webp', 'avif'],
        'category' => 'advanced',
    ],

    'big_link' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-fw fa-external-link-alt',
        'color' => '#cc0084',
        'has_statistics' => true,
        'themable' => true,
        'display_dynamic_name' => 'name',
        'whitelisted_thumbnail_image_extensions' => ['jpg', 'jpeg', 'png', 'svg', 'gif', 'webp', 'avif'],
        'category' => 'standard',
    ],
    'faq' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-feather',
        'color' => '#da2a73',
        'has_statistics' => false,
        'themable' => true,
        'display_dynamic_name' => false,
        'category' => 'advanced',
    ],
    'typeform' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-keyboard',
        'color' => '#000000',
        'has_statistics' => false,
        'themable' => false,
        'display_dynamic_name' => false,
        'category' => 'embeds',
    ],
    'calendly' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-calendar',
        'color' => '#2d69f6',
        'has_statistics' => false,
        'themable' => false,
        'display_dynamic_name' => false,
        'category' => 'embeds',
    ],
    'discord' => [
        'type' => 'ultimate',
        'icon' => 'fab fa-discord',
        'color' => '#7289D9',
        'has_statistics' => false,
        'themable' => false,
        'display_dynamic_name' => false,
        'category' => 'embeds',
    ],
    'facebook' => [
        'type' => 'ultimate',
        'icon' => 'fab fa-facebook',
        'color' => '#4267B2',
        'has_statistics' => false,
        'themable' => false,
        'display_dynamic_name' => false,
        'whitelisted_hosts' => ['www.facebook.com', 'fb.watch'],
        'category' => 'embeds',
    ],
    'reddit' => [
        'type' => 'ultimate',
        'icon' => 'fab fa-reddit',
        'color' => '#FF4500',
        'has_statistics' => false,
        'themable' => false,
        'display_dynamic_name' => false,
        'whitelisted_hosts' => ['www.reddit.com'],
        'category' => 'embeds',
    ],
    'audio' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-volume-up',
        'color' => '#003b63',
        'has_statistics' => false,
        'themable' => false,
        'display_dynamic_name' => 'name',
        'whitelisted_file_extensions' => ['mp3', 'm4a'],
        'category' => 'standard',
    ],
    'video' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-video',
        'color' => '#0c3db7',
        'has_statistics' => false,
        'themable' => false,
        'display_dynamic_name' => 'name',
        'whitelisted_file_extensions' => ['mp4', 'webm'],
        'category' => 'standard',
    ],
    'iframe' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-crop-alt',
        'color' => '#366bff',
        'has_statistics' => false,
        'themable' => false,
        'display_dynamic_name' => false,
        'category' => 'standard',
    ],
    'file' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-file',
        'color' => '#8c8c8c',
        'has_statistics' => true,
        'themable' => true,
        'display_dynamic_name' => 'name',
        'whitelisted_file_extensions' => ['pdf', 'zip', 'rar', 'doc', 'docx'],
        'whitelisted_thumbnail_image_extensions' => ['jpg', 'jpeg', 'png', 'svg', 'gif', 'webp', 'avif'],
        'category' => 'standard',
    ],
    'countdown' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-clock',
        'color' => '#2b2b2b',
        'has_statistics' => false,
        'themable' => false,
        'display_dynamic_name' => false,
        'category' => 'advanced',
    ],
    'cta' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-comments',
        'color' => '#3100d6',
        'has_statistics' => true,
        'themable' => true,
        'display_dynamic_name' => 'name',
        'whitelisted_thumbnail_image_extensions' => ['jpg', 'jpeg', 'png', 'svg', 'gif', 'webp', 'avif'],
        'category' => 'standard',
    ],
    'external_item' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-money-bill-wave',
        'color' => '#00ce18',
        'has_statistics' => true,
        'themable' => false,
        'display_dynamic_name' => 'name',
        'whitelisted_thumbnail_image_extensions' => ['jpg', 'jpeg', 'png', 'svg', 'gif', 'webp', 'avif'],
        'category' => 'advanced',
    ],
    'share' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-share-square',
        'color' => '#00d3ac',
        'has_statistics' => true,
        'themable' => true,
        'display_dynamic_name' => 'name',
        'whitelisted_thumbnail_image_extensions' => ['jpg', 'jpeg', 'png', 'svg', 'gif', 'webp', 'avif'],
        'category' => 'advanced',
    ],
    'coupon' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-tags',
        'color' => '#6fd9f0',
        'has_statistics' => true,
        'themable' => true,
        'display_dynamic_name' => 'name',
        'whitelisted_thumbnail_image_extensions' => ['jpg', 'jpeg', 'png', 'svg', 'gif', 'webp', 'avif'],
        'category' => 'advanced',
    ],
    'youtube_feed' => [
        'type' => 'ultimate',
        'icon' => 'fab fa-youtube',
        'color' => '#282828',
        'has_statistics' => false,
        'themable' => true,
        'display_dynamic_name' => false,
        'category' => 'advanced',
    ],
    'timeline' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-ellipsis-v',
        'color' => '#3c526d',
        'has_statistics' => false,
        'themable' => false,
        'display_dynamic_name' => false,
        'category' => 'advanced',
    ],
    'review' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-star',
        'color' => '#ffe100',
        'has_statistics' => false,
        'themable' => true,
        'display_dynamic_name' => 'title',
        'whitelisted_image_extensions' => ['jpg', 'jpeg', 'png', 'svg', 'gif', 'webp', 'avif'],
        'category' => 'advanced',
    ],
    'image_slider' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-clone',
        'color' => '#290b5b',
        'has_statistics' => true,
        'themable' => false,
        'display_dynamic_name' => false,
        'whitelisted_image_extensions' => ['jpg', 'jpeg', 'png', 'svg', 'gif', 'webp', 'avif'],
        'category' => 'advanced',
    ],
    'pdf_document' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-file-pdf',
        'color' => '#AA1501',
        'has_statistics' => true,
        'themable' => true,
        'display_dynamic_name' => 'name',
        'whitelisted_file_extensions' => ['pdf'],
        'whitelisted_thumbnail_image_extensions' => ['jpg', 'jpeg', 'png', 'svg', 'gif', 'webp', 'avif'],
        'category' => 'embeds',
    ],
    'powerpoint_presentation' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-file-powerpoint',
        'color' => '#f58968',
        'has_statistics' => true,
        'themable' => true,
        'display_dynamic_name' => 'name',
        'whitelisted_file_extensions' => ['ppt', 'pptx', 'odp'],
        'whitelisted_thumbnail_image_extensions' => ['jpg', 'jpeg', 'png', 'svg', 'gif', 'webp', 'avif'],
        'category' => 'embeds',
    ],
    'excel_spreadsheet' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-file-excel',
        'color' => '#3bac53',
        'has_statistics' => true,
        'themable' => true,
        'display_dynamic_name' => 'name',
        'whitelisted_file_extensions' => ['xls', 'xlsx', 'ods'],
        'whitelisted_thumbnail_image_extensions' => ['jpg', 'jpeg', 'png', 'svg', 'gif', 'webp', 'avif'],
        'category' => 'embeds',
    ],
    'markdown' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-sticky-note',
        'color' => '#ff8300',
        'has_statistics' => false,
        'themable' => true,
        'display_dynamic_name' => false,
        'category' => 'advanced',
    ],
    'rumble' => [
        'type' => 'ultimate',
        'icon' => 'fas fa-play',
        'color' => '#85C742',
        'has_statistics' => false,
        'themable' => false,
        'display_dynamic_name' => false,
        'whitelisted_hosts' => ['rumble.com'],
        'category' => 'embeds',
    ],
    'telegram' => [
        'type' => 'ultimate',
        'icon' => 'fab fa-telegram',
        'color' => '#0088cc',
        'has_statistics' => false,
        'themable' => false,
        'display_dynamic_name' => false,
        'whitelisted_hosts' => ['t.me'],
        'category' => 'embeds',
    ],
];
